/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.commands.CategoryCheckCommand;
import shadows.apotheosis.deadly.commands.LootifyCommand;
import shadows.apotheosis.deadly.commands.ModifierCommand;
import shadows.apotheosis.deadly.commands.RarityCommand;
import shadows.apotheosis.deadly.loot.LootCategory;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;

public class DeadlyModuleEvents {
    private static final Set<Float> values = ImmutableSet.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.33f), (Object)Float.valueOf(0.5f), (Object)Float.valueOf(1.0f), (Object[])new Float[]{Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.33f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.1f), Float.valueOf(2.25f), Float.valueOf(2.33f), Float.valueOf(2.5f), Float.valueOf(3.0f)});

    @SubscribeEvent
    public void reloads(AddReloadListenerEvent e) {
    }

    @SubscribeEvent
    public void cmds(RegisterCommandsEvent e) {
        RarityCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        CategoryCheckCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        LootifyCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        ModifierCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void sortModifiers(ItemAttributeModifierEvent e) {
        if (e.getModifiers() == null || e.getModifiers().isEmpty() || FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return;
        }
        TreeMultimap map = TreeMultimap.create((k1, k2) -> k1.getRegistryName().compareTo(k2.getRegistryName()), (v1, v2) -> {
            int compOp = Integer.compare(v1.m_22217_().ordinal(), v2.m_22217_().ordinal());
            int compValue = Double.compare(v2.m_22218_(), v1.m_22218_());
            return compOp == 0 ? (compValue == 0 ? v1.m_22214_().compareTo(v2.m_22214_()) : compValue) : compOp;
        });
        for (Map.Entry ent : e.getModifiers().entries()) {
            if (ent.getKey() != null && ent.getValue() != null) {
                map.put((Object)((Attribute)ent.getKey()), (Object)((AttributeModifier)ent.getValue()));
                continue;
            }
            DeadlyModule.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)e.getItemStack(), ent.getKey(), ent.getValue());
        }
        ObfuscationReflectionHelper.setPrivateValue(ItemAttributeModifierEvent.class, (Object)e, (Object)map, (String)"unmodifiableModifiers");
    }

    @SubscribeEvent
    public void affixModifiers(ItemAttributeModifierEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
            affixes.forEach((afx, lvl) -> afx.addModifiers(stack, lvl.floatValue(), e.getSlotType(), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)e).addModifier(arg_0, arg_1)));
        }
    }

    @SubscribeEvent
    public void drawSpeed(LivingEntityUseItemEvent.Tick e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double t = player.m_21051_(Apoth.Attributes.DRAW_SPEED).m_22135_() - 1.0;
            if (t == 0.0 || !LootCategory.forItem(e.getItem()).isRanged()) {
                return;
            }
            for (float clamped = values.stream().filter(f -> (double)f.floatValue() >= t).min(Float::compareTo).orElse(Float.valueOf(3.0f)).floatValue(); clamped > 0.0f; clamped -= 1.0f) {
                if (e.getEntity().f_19797_ % (int)Math.floor(1.0 / Math.min(1.0, t)) != 0) continue;
                e.setDuration(e.getDuration() - 1);
            }
        }
    }
}

